<%@ Control Language="c#" AutoEventWireup="false" Codebehind="SearchResults.ascx.cs" Inherits="Mediachase.UI.Web.Home.Modules.SearchResults" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\..\Modules\BlockHeader.ascx" %>
<table id="tbSearchForm" runat="server" class="ibn-stylebox text" style="margin-top: 0px;margin-bottom:0px;border-bottom:0px;" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<tr>
		<td><ibn:blockheader id="secHeader" title="" runat="server"></ibn:blockheader></td>
	</tr>
	<tr>
		<td class="ibn-navline ibn-alternating text" style="Padding:14px;">
			<%=LocRM.GetString("SearchString") %>:
			<asp:TextBox CssClass="text" Width="150" ID="tbSearchstr" Runat="server"></asp:TextBox>
			<asp:ImageButton Runat="server" id="btnSearch" Width="16" Height="
			16" ImageUrl="../../layouts/images/search.gif" ImageAlign="AbsMiddle"></asp:ImageButton>
		</td>
	</tr>
</table>
<table id="tbSearchNoItems" runat="server" Visible="false" class="ibn-stylebox text" style="MARGIN-TOP: 0px;border-top:0px;" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<tr>
		<td style="PADDING: 5px" valign="top">
			<span id="Span1" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
</table>
<table id="tbSearchResults" runat="server" class="ibn-stylebox text" style="MARGIN-TOP: 0px;border-top:0px;" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Projects") %>:</b>
			<asp:DataGrid id="dgProjects" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<columns>
					<asp:boundcolumn visible="False" datafield="ProjectId">
						<headerstyle cssclass="ibn-vh2"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
					</asp:boundcolumn>
					<asp:TemplateColumn headertext="Title">
						<headerstyle cssclass="ibn-vh2"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetProjectStatus (
							(int)DataBinder.Eval(Container.DataItem, "ProjectId"),
							DataBinder.Eval(Container.DataItem, "Title").ToString(),
							(int)DataBinder.Eval(Container.DataItem, "StatusId")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:boundcolumn datafield="TargetStartDate" headertext="Start Date" dataformatstring="{0:d}">
						<headerstyle width="100px" cssclass="ibn-vh2"></headerstyle>
						<itemstyle width="100px" cssclass="ibn-vb2"></itemstyle>
					</asp:boundcolumn>
					<asp:boundcolumn datafield="TargetFinishDate" headertext="Finish Date" dataformatstring="{0:d}">
						<headerstyle width="110px" cssclass="ibn-vh2"></headerstyle>
						<itemstyle width="110px" cssclass="ibn-vb2"></itemstyle>
					</asp:boundcolumn>
					<asp:templatecolumn headertext="Manager">
						<headerstyle cssclass="ibn-vh2" width="190px"></headerstyle>
						<itemstyle cssclass="ibn-vb2" width="190px"></itemstyle>
						<itemtemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetUserStatus((int)DataBinder.Eval(Container.DataItem, "ManagerId"))%>
						</itemtemplate>
					</asp:templatecolumn>
				</columns>
			</asp:DataGrid>
			<span id="spanPrjLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Tasks") %>:</b>
			<asp:DataGrid id="dgTasks" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<Columns>
					<asp:TemplateColumn SortExpression="Title" HeaderText="Title">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%#
								Mediachase.UI.Web.Util.CommonHelper.GetTaskToDoLink 
								(
									(int)DataBinder.Eval(Container.DataItem, "ItemId"),
									(int)DataBinder.Eval(Container.DataItem, "IsToDo"),
									DataBinder.Eval(Container.DataItem, "Title").ToString(),
									(int)DataBinder.Eval(Container.DataItem, "StateId")
								)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="IsToDo" HeaderText="Type">
						<HeaderStyle CssClass="ibn-vh2" Width="60px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="60px"></ItemStyle>
						<ItemTemplate>
							<%# GetTypeString((int)DataBinder.Eval(Container.DataItem,"IsToDo"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="IsCompleted" HeaderText="Completion">
						<HeaderStyle CssClass="ibn-vh2" Width="90px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="90px"></ItemStyle>
						<ItemTemplate>
							<%# GetStatus((bool)DataBinder.Eval(Container.DataItem,"IsCompleted"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="StartDate" DataFormatString="{0:d}" SortExpression="StartDate" HeaderText="Start Date">
						<HeaderStyle CssClass="ibn-vh2" Width="80px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="80px"></ItemStyle>
					</asp:BoundColumn>
					<asp:BoundColumn DataField="FinishDate" DataFormatString="{0:d}" SortExpression="FinishDate" HeaderText="Finish Date">
						<HeaderStyle CssClass="ibn-vh2" Width="80px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="80px"></ItemStyle>
					</asp:BoundColumn>
				</Columns>
			</asp:DataGrid>
			<span id="spanTaskLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Events") %>:</b>
			<asp:DataGrid id="dgEvents" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<Columns>
					<asp:BoundColumn Visible="False" DataField="EventId">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn SortExpression="Title" HeaderText="Title">
						<HeaderStyle HorizontalAlign="Left" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle HorizontalAlign="Left" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<a href="../Events/EventView.aspx?EventID=<%# DataBinder.Eval(Container.DataItem, "EventId")%>"><%# DataBinder.Eval(Container.DataItem, "Title")%></a>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="Type" HeaderText="Type">
						<HeaderStyle HorizontalAlign="Left" CssClass="ibn-vh2" Width="100px"></HeaderStyle>
						<ItemStyle HorizontalAlign="Left" CssClass="ibn-vb2" Width="100px"></ItemStyle>
						<ItemTemplate>
							<%# GetTypeString((Mediachase.IBN.Business.CalendarEntry.EventType)DataBinder.Eval(Container.DataItem,"TypeId"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
						<asp:TemplateColumn SortExpression="StartDate" HeaderText="Start Date">
						<HeaderStyle Width="100px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="100px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
								<%# ((DateTime)DataBinder.Eval(Container.DataItem,"StartDate")).ToShortDateString() %>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="FinishDate" HeaderText="Finish Date"> 
						<HeaderStyle Width="100px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="100px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
								<%# ((DateTime)DataBinder.Eval(Container.DataItem,"FinishDate")).ToShortDateString() %>
						</ItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:DataGrid>
			<span id="spanEventLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Documents") %>:</b>
			<asp:DataGrid id="dgDocuments" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<Columns>
					<asp:BoundColumn Visible="False" DataField="DocumentID">
					</asp:BoundColumn>
					<asp:TemplateColumn ItemStyle-Width="18">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetPriority (
								(int)DataBinder.Eval(Container.DataItem, "PriorityId"),
								(string)DataBinder.Eval(Container.DataItem, "PriorityName"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Title">
						<HeaderStyle HorizontalAlign="Left" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle HorizontalAlign="Left" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<a href="../Documents/DocumentView.aspx?DocumentID=<%# DataBinder.Eval(Container.DataItem, "DocumentID")%>"><img src="../layouts/images/icons/document.gif" width="16" height="16" border="0" align="absmiddle"> <%# DataBinder.Eval(Container.DataItem, "Title")%></a>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Type">
						<HeaderStyle HorizontalAlign="Left" CssClass="ibn-vh2" Width="100px"></HeaderStyle>
						<ItemStyle HorizontalAlign="Left" CssClass="ibn-vb2" Width="100px"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem,"StatusName")%>
						</ItemTemplate>
					</asp:TemplateColumn>
						<asp:TemplateColumn HeaderText="Creation Date">
						<HeaderStyle Width="100px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="100px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
								<%# ((DateTime)DataBinder.Eval(Container.DataItem,"CreationDate")).ToShortDateString() %>
						</ItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:DataGrid>
			<span id="spanDocLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Issues") %>:</b>
			<asp:DataGrid id="dgIncidents" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<Columns>
					<asp:BoundColumn Visible="False" DataField="IncidentId">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn ItemStyle-Width="18">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetPriority (
								(int)DataBinder.Eval(Container.DataItem, "PriorityId"),
								(string)DataBinder.Eval(Container.DataItem, "PriorityName"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Title">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
								<%# Mediachase.UI.Web.Util.CommonHelper.GetIncidentTitle
									(
										(string)DataBinder.Eval(Container.DataItem, "Title"),
										(int)DataBinder.Eval(Container.DataItem, "IncidentId"),
										(int)DataBinder.Eval(Container.DataItem, "StatusId"),
										(string)DataBinder.Eval(Container.DataItem, "StatusName")
									)
								%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Status">
						<HeaderStyle Width="60px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="60px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem, "StatusName")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:BoundColumn DataField="CreationDate" HeaderText="Creation Date" DataFormatString="{0:d}">
						<HeaderStyle Width="90px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="90px" CssClass="ibn-vb2"></ItemStyle>
					</asp:BoundColumn>
					<asp:TemplateColumn HeaderText="CreatedBy">
						<HeaderStyle Width="150px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="150px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetUserStatus((int)DataBinder.Eval(Container.DataItem, "CreatorId"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn HeaderText="Manager">
						<HeaderStyle Width="150px" CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="150px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetUserStatus((int)DataBinder.Eval(Container.DataItem, "ManagerId"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:DataGrid>
			<span id="spanIssLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Users") %>:</b>
			<asp:DataGrid id="dgUsers" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<columns>
					<asp:boundcolumn visible="false" datafield="UserId"></asp:boundcolumn>
					<asp:TemplateColumn HeaderText="User Name">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetUserStatus((int)DataBinder.Eval(Container.DataItem, "UserId"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:boundcolumn HeaderStyle-CssClass="ibn-vh2" ItemStyle-CssClass="ibn-vb2" datafield="Email" headertext="Email" headerstyle-width="140" itemstyle-width="140" sortexpression="sortSize"></asp:boundcolumn>
				</columns>
			</asp:DataGrid>
			<span id="spanUserLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" class="ibn-navline">
			<b><%=LocRM.GetString("Groups") %>:</b>
			<asp:DataGrid id="dgGroups" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<columns>
					<asp:boundcolumn visible="false" datafield="GroupId"></asp:boundcolumn>
					<asp:TemplateColumn HeaderText="Group Name">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetUserStatus((int)DataBinder.Eval(Container.DataItem, "GroupId"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
				</columns>
			</asp:DataGrid>
			<span id="spanGroupLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
	<tr>
		<td style="PADDING: 5px" valign="top" >
			<b><%=LocRM.GetString("Files") %>:</b>
			<asp:DataGrid id="dgFiles" runat="server" allowpaging="False" allowsorting="False" cellpadding="3" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%" EnableViewState="False">
				<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
				<ItemStyle CssClass="ibn-vb2"></ItemStyle>
				<columns>
					<asp:templatecolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="16" itemstyle-width="16">
						<itemtemplate>
							<img src='<%# DataBinder.Eval(Container.DataItem, "Icon")%>' width="16" height="16">
						</itemtemplate>
					</asp:templatecolumn>
					<asp:boundcolumn datafield="Title" ItemStyle-CssClass="ibn-vb2" HeaderStyle-CssClass="ibn-vh2"></asp:boundcolumn>
					<asp:boundcolumn datafield="Size" ItemStyle-CssClass="ibn-vb2" HeaderStyle-CssClass="ibn-vh2" headerstyle-width="70"></asp:boundcolumn>
				</columns>
			</asp:DataGrid>
			<span id="spanFilesLbl" class="ibn-alerttext" runat="server">
				<br><br>
				<%=LocRM.GetString("tNoItems") %>
			</span>
		</td>
	</tr>
</table>



